//--------------------------------------------------------
//  ダブル･バッファの template クラス
//      内部のバッファは通常の配列を使用
//
//  2019/11/22, Copyright (c) 2019 MIKAMI, Naoki
//--------------------------------------------------------

#ifndef DOUBLE_BUFFER_2DARRAY_HPP
#define DOUBLE_BUFFER_2DARRAY_HPP

template<class T, int N> class DoubleBuffer
{
public:
    // コンストラクタ
    explicit DoubleBuffer(T initialValue)
        : ping_(0), pong_(1), index_(0), full_(false)
    {
        for (int k=0; k<2; k++)
            for (int n=0; n<N; n++) buf_[k][n] = initialValue;
    }
    
    // データを格納
    void Store(T data)  { buf_[ping_][index_++] = data; }
    
    // 出力バッファからデータの取り出し
    T Get(int n) const { return buf_[pong_][n]; }

    // バッファが満杯でバッファを切り替える
    void IfFullSwitch()
    {
        if (index_ < N) return;

        ping_ ^= 0x1;   // バッファ切換えのため
        pong_ ^= 0x1;   // バッファ切換えのため
        index_ = 0;
        full_ = true;
    }

    // バッファが満杯で，true を返す
    bool IsFull()
    {
        bool temp = full_;
        if (full_) full_ = false;
        return temp;
    }

private:
    T buf_[2][N];       // 標本化したデータのバッファ
    int ping_, pong_;   // バッファ切替用
    int index_;         // 入力データのカウンタ
    bool full_;         // 満杯の場合 true

    // コピー･コンストラクタおよび代入演算子の禁止のため
    DoubleBuffer(const DoubleBuffer&);
    DoubleBuffer& operator=(const DoubleBuffer&);
};
#endif  // DOUBLE_BUFFER_2DARRAY_HPP

