//-----------------------------------------------------
//  縦続形 IIR フィルタの次数と係数の定義
//
//  2020/11/08, Copyright (c) 2020 MIKAMI, Naoki
//-----------------------------------------------------

#include "Biquad.hpp"

// FFT アナライザで使うフィルタ
//      標本化周波数が 100 kHz の場合，5 kHz 以上で
//      少なくとも 60 dB 減衰させる LPF

// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 10 次
// 標本化周波数：100.00 kHz
// 遮断周波数　：  4.80 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：60.00 dB
const int ORDER1_ = 10;
const Biquad::Coefs CK1_[] = {
    { 1.824022E+00f, -8.381143E-01f, -9.384721E-01f, 1.0f},  // 1段目
    { 1.856865E+00f, -9.028289E-01f, -1.790351E+00f, 1.0f},  // 2段目
    { 1.884825E+00f, -9.577163E-01f, -1.875764E+00f, 1.0f},  // 3段目
    { 1.898856E+00f, -9.845865E-01f, -1.896090E+00f, 1.0f},  // 4段目
    { 1.905948E+00f, -9.962457E-01f, -1.901699E+00f, 1.0f}}; // 5段目
const float G01_ = 1.221772E-03f;    // 利得定数



// 白色雑音発生器で使うフィルタ
//      標本化周波数が 100 kHz の場合，
//      100/(4π) ≒7.96 kHz 以上で
//      少なくとも 60 dB 減衰させる LPF

// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 6 次
// 標本化周波数：100.00 kHz
// 遮断周波数　：  5.00 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：60.00 dB
const int ORDER2_ = 6;
const Biquad::Coefs CK2_[] = {
    { 1.789361E+00f, -8.093387E-01f, -6.031744E-01f, 1.0f},  // 1段目
    { 1.825484E+00f, -8.899602E-01f, -1.690793E+00f, 1.0f},  // 2段目
    { 1.869667E+00f, -9.677499E-01f, -1.803334E+00f, 1.0f}}; // 3段目
const float G02_ = 1.404132E-03f;    // 利得定数