//---------------------------------------------------------------------
//  スペクトル解析の結果を PC へ転送するためのクラス
//
//  2020/02/05, Copyright (c) 2020 MIKAMI, Naoki
//---------------------------------------------------------------------

#include <string>
#include "Array.hpp"
#include "SerialRxTxIntr.hpp"
using namespace Mikami;

#ifndef XFER_CONVERT_TOPC_HPP
#define XFER_CONVERT_TOPC_HPP

class Xfer
{
public:
    // コンストラクタ
    Xfer(SerialRxTxIntr& rxTx, int size)
        : SIZE_(size), xn_(size), rxTx_(rxTx) {}
        
    // スペクトル解析の結果を転送する形式に変換
    //      yAbs    FFT の結果の絶対値
    //      magn    倍率
    void Convert(const float yAbs[], float magn = 1.0f)
    {
        const float MAX = 10000;
        for (int n=0; n<SIZE_; n++)
        {
            float x = magn*yAbs[n];
            xn_[n] = (x > MAX) ? MAX : (uint16_t)x; 
        }
    }

    // データを PC へ転送（0 ～ 10,000 の範囲の値を 2 文字で表すコード化を利用）
    void ToPC()
    {
        string str = "";
        for (int n=0; n<SIZE_; n++)
        {
            div_t a = div(xn_[n], 100);
            str += a.quot + 0x10;
            str += a.rem + 0x10;
        }
        rxTx_.TxString(str+"\n");
        rxTx_.TxString("EOT\n");
    }
    
private:
    const int SIZE_;        // PC に送るデータ数
    Array<uint16_t> xn_;    // PC に送るデータ
    SerialRxTxIntr& rxTx_;

    // コピー･コンストラクタおよび代入演算子の禁止のため
    Xfer(const Xfer&);
    Xfer& operator=(const Xfer&);
};
#endif  // XFER_CONVERT_TOPC_HPP