//-------------------------------------------------------------------
//  Blackman 窓による窓掛け
//      ゼロ詰め（zero-padding）の機能を持つ
//
//  2020/11/07, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------------

#ifndef HAMMING_WINDOW_HPP
#define HAMMING_WINDOW_HPP

#include "mbed.h"
#include "Array.hpp"

namespace Mikami
{
    class BlackmanWindow
    {
    public:
        // コンストラクタ
        BlackmanWindow(uint16_t nData, uint16_t nFft)
                : N_(nData), NFFT_(nFft), w_(nData)
        {
            const float PI2L = 6.283185f/(float)nData;
            const float PI4L = 2*PI2L;
            for (int k=0; k<nData; k++)
                w_[k] = 0.42f - 0.5f*cosf(k*PI2L) + 0.08f*cosf(k*PI4L);
        }
        
        // デストラクタ
        virtual ~BlackmanWindow() {}
        
        // 窓掛けを実行
        void Execute(const Array<float> &x, Array<float> &y)
        {
            for (int n=0; n<N_; n++) y[n] = x[n]*w_[n];
            for (int n=N_; n<NFFT_; n++) y[n] = 0;
        }

    private:
        const int N_;
        const int NFFT_;
                
        Array<float> w_;

        // コピー･コンストラクタおよび代入演算子の禁止のため
        BlackmanWindow(const BlackmanWindow& );
        BlackmanWindow& operator=(const BlackmanWindow& );
    };
}
#endif  // HAMMING_WINDOW_HPP