//--------------------------------------------------------------
//  AD Conversion by interrupt using ADC2 or ADC3 on STM32F446
//
//  STM32F446 の ADC2 または ADC3 を使って割り込みにより
//  アナログ信号を入力するクラス
//      AdcSingle クラスの派生クラス
//
//  2017/02/16, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F446_ADC_SINGLE_INTERRUPT_HPP
#define F446_ADC_SINGLE_INTERRUPT_HPP

#include "F446_ADC_Single.hpp"

namespace Mikami
{
    class AdcSingle_Intr : public AdcSingle
    {
    public:
        AdcSingle_Intr(PinName pin, int frequency)
            : AdcSingle(pin, frequency)
        {   
            if (pin == A0) ADC2->CR1 |= ADC_CR1_EOCIE;
            else           ADC3->CR1 |= ADC_CR1_EOCIE;
        }

        virtual ~AdcSingle_Intr() {}

        // -1.0f <= ad1, ad2 <= 1.0f
        virtual float Read() { return ToFloat(adc_->DR); }

        // 0 <= ad1, ad2 <= 4095
        virtual uint16_t ReadUint() { return adc_->DR; }

        // Set interrupt vector and enable IRQ of ADC
        void SetIntrVec(void (*Func)())
        {
            NVIC_SetVector(ADC_IRQn, (uint32_t)Func);   // See "cmsis_nvic.h"
            NVIC_EnableIRQ(ADC_IRQn);                   // See "core_cm4.h"
        }
        
        void DisableAdcIntr()
        {   NVIC_DisableIRQ(ADC_IRQn); }
        
    private:
        // for inhibition of copy constructor
        AdcSingle_Intr(const AdcSingle_Intr&);
        // for inhibition of substitute operator
        AdcSingle_Intr& operator=(const AdcSingle_Intr&);     
    };
}
#endif  // F446_ADC_DUAL_INTERRUPT_HPP
