//--------------------------------------------------------
//  Class for buit-in single DAC on STM32F446
//
//  STM32F446 内蔵の DAC 用のクラス
//      DAC_OUT1: A2  (PA_4)
//      DAC_OUT2: D13 (PA_5)
//
//  2017/02/21, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------

#include "F446_DAC_Single.hpp"

namespace Mikami
{
    DacSingle::DacSingle(PinName pin) : da_(pin)
    {
        if (pin == A2)
        {
            DAC->CR = DAC_CR_EN1 | DAC_CR_TEN1 | DAC_CR_TSEL1;
            fpWriteDac = &DacSingle::WriteDac1;
        }
        else
        {
            DAC->CR = DAC_CR_EN2 | DAC_CR_TEN2 | DAC_CR_TSEL2;
            fpWriteDac = &DacSingle::WriteDac2;
        }
    }

    // Write single-channel data
    void DacSingle::WriteDac1(uint16_t val)
    {
        DAC->DHR12R1 = val;
        DAC->SWTRIGR = DAC_SWTRIGR_SWTRIG1;
    }
    void DacSingle::WriteDac2(uint16_t val)
    {
        DAC->DHR12R2 = val;
        DAC->SWTRIGR = DAC_SWTRIGR_SWTRIG2;
    }

    void DacSingle::ScfClock(uint32_t clock)
    {
        PwmOut clockSCF(D12);   // PA6

        uint32_t arr;
        if ((RCC->DCKCFGR & RCC_DCKCFGR_TIMPRE) == RCC_DCKCFGR_TIMPRE)
            arr = SystemCoreClock/clock - 1;
        else
            arr = SystemCoreClock/(2*clock) - 1;
        TIM3->ARR =  arr;
        TIM3->PSC = 0;

        // Set capture/compare register 1
        TIM3->CCR1 = (TIM3->ARR + 1)/2;    
    }
}
