//--------------------------------------------------------
//  Class for buit-in single DAC on STM32F446 ---- Header
//      TIM3 is used for clock to external SCF
//
//  STM32F446 内蔵の DAC 用のクラス（ヘッダ）
//      TIM3 を外付けの SCF のクロックとして使用
//      A2  (PA_4)： 左 ---- デフォルト
//      D13 (PA_5)： 右
//
//  2017/02/21, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------

#include "mbed.h"

#ifndef STM32F446xx
#error Select NUCLEO-F446RE.
#endif

#ifndef F446_DAC_SINGLE_HPP
#define F446_DAC_SINGLE_HPP

namespace Mikami
{
    class DacSingle
    {
    public:
        // Constructor
        DacSingle(PinName pin = A2);

        virtual ~DacSingle() {}

        // -1.0f <= data <= 1.0f
       void Write(float data) { WriteDac(ToUint16(data)); }

        // 0 <= data1<= 4095
        void Write(uint16_t data) { WriteDac(__USAT(data, BIT_WIDTH_)); }
        
        // Set TIM3 for clock of switched-capacitor filter
        void ScfClock(uint32_t clock);

    private:
        void (DacSingle::*fpWriteDac)(uint16_t);

        static const int BIT_WIDTH_ = 12;
        AnalogOut da_;

        // Write single-channel data
        void WriteDac1(uint16_t val);
        void WriteDac2(uint16_t val);
        
        void WriteDac(uint16_t val) { (this->*fpWriteDac)(val); }

        // Saturate float to an unsigned 16-bit value
        uint16_t ToUint16(float val)
        {   return __USAT((val + 1.0f)*2047.0f, BIT_WIDTH_); }

        // for inhibition of copy constructor
        DacSingle(const DacSingle&);
        // for inhibition of substitute operator
        DacSingle& operator=(const DacSingle&);     
    };
}
#endif  // F446_DAC_SINGLEL_HPP
