//--------------------------------------------------------
//  Class for buit-in dual DAC on STM32F446
//
//  STM32F446 内蔵の DAC 用のクラス
//      DAC_OUT1: A2  (PA_4), 左
//      DAC_OUT2: D13 (PA_5), 右
//
//  2016/11/12, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------

#include "F446_DAC.hpp"

namespace Mikami
{
    void DacDual::ScfClock(uint32_t clock)
    {
        PwmOut clockSCF(D12);   // PA6

        uint32_t arr;
        if ((RCC->DCKCFGR & RCC_DCKCFGR_TIMPRE) == RCC_DCKCFGR_TIMPRE)
            arr = SystemCoreClock/clock - 1;
        else
            arr = SystemCoreClock/(2*clock) - 1;
        TIM3->ARR =  arr;
        TIM3->PSC = 0;

        // Set capture/compare register 1
        TIM3->CCR1 = (TIM3->ARR + 1)/2;    
    }
}
