//---------------------------------------
//  異なる型の Array クラスの参照の代入の例
//---------------------------------------
#define DEBUG_ARRAY_CHECK   // 範囲のチェック有効
#include "Array.hpp"
#include <string>

using namespace Mikami;

struct struct1 { int x1; float x2; string str; };
struct struct2 { int x1; float x2; string str; };

void ReferenceArray()
{
    // 複合リテラルを使ってデータを割り当てる
    Array<struct1> xa1(2, (struct1[]){{ 8, 0.2f, "abc"},
                                      {-3, 0.4f, "xyz"}});

    // 同じデータ配置で，型名の違う構造体同士で，片方の構造体 struct1 の参照を
    // もう一方の構造体 struct2 の参照に代入する
    // xa2 は xa1 の別名なので，xa2 の内容を変えると，xa1 の対応する内容も変わる
    Array<struct2> &xa2 = (Array<struct2> &)xa1;    // ここで使っている

    printf("\r\nxa1[1].x1 = %d\r\n",  xa1[1].x1);
    printf("xa1[1].x2 = %f\r\n",  xa1[1].x2);
    printf("xa1[1].str = %s\r\n", (xa1[1].str).c_str());

    printf("\r\nxa2[1].x1 = %d\r\n",  xa2[1].x1);
    printf("xa2[1].x2 = %f\r\n",  xa2[1].x2);
    printf("xa2[1].str = %s\r\n", (xa2[1].str).c_str());

    xa2[1].str = "ABCDEFG";     // xa2[1].str に新たな値を代入した
    printf("\r\nxa2[1].str に新たな値を代入したので，");
    printf("xa1[1].str の値も変わっている\r\n");
    printf("xa1[1].str = %s\r\n", (xa1[1].str).c_str());
}
