//------------------------------------------------------------
//  実行時ポリモーフィズムの例
//
//  2016/04/12, Copyright (c) 2016 MIKAMI, Naoki
//------------------------------------------------------------

#include "mbed.h"

class Base
{
public:
    Base() {}
    virtual void Execute() { printf("    Base class\r\n"); }
};

class Derived1 : public Base
{
public:
    Derived1() {}
    virtual void Execute() { printf("    Derived1 class\r\n"); }
};

class Derived2 : public Base
{
public:
    Derived2() {}
    virtual void Execute() { printf("    Derived2 class\r\n"); }
};

void Print(Base *obj) { obj->Execute(); }

void MyPolyMorphism()
{
    Base base;
    Derived1 drv1;
    Derived2 drv2;
    
    // 例 1
    printf("例 1:\r\n");
    Base *func[3] = { &base, &drv1, &drv2 };
    for (int n=0; n<3; n++) func[n]->Execute();
    
    // 例 2
    printf("例 2:\r\n");
    Base *ptr;
    ptr = &drv2;
    ptr->Execute();
    
    ptr = &drv1;
    ptr->Execute();
    
    // 例 3
    printf("例 3:\r\n");
    Print(&drv2);
}