//--------------------------------------------------
//  算術関数のテスト
//      log10f(), fabsf(), floorf(), min(), max()
//--------------------------------------------------

#include "mbed.h"
//#include <cmath>      // このインクルード文は不要
#include <algorithm>    // min(), max() を使う場合は <algorithm> をインクルードすること

void MyMath()
{
    printf("\r\nStart of \"MyMath\"\r\n");

    float x1 = log10f(100.0f);
    printf("log10(100) = %f\r\n", x1);

    x1 = log10f(2.0f);
    printf("log10(2) = %f\r\n", x1);

    x1 = fabsf(-0.123f);
    printf("|x1| = %f\r\n", x1);

    x1 = floorf(2.1f);
    printf("floor(2.1) = %f\r\n", x1);

    // min(), max() を使う場合は <algorithm> をインクルードすること
    x1 = min(0.1f, -2.4f);
    printf("min(0.1, -2.4) = %f\r\n", x1);
    float x2 = max(0.1f, -2.4f);
    printf("max(0.1, -2.4) = %f\r\n", x2);

    int x3 = max(1, 2);
    printf("max(1, 2) = %d\r\n", x3);

    printf("End of \"MyMath\"\r\n");
}

