// 関数ポインタの使用例
#include <cmath>

void (*fp1)(int);
void (*fp2)(int&);

// typedef を使って一種の型名として扱う例
typedef float (*FP3)(float);
FP3 fp3Sin = sinf;
FP3 fp3Cos = cosf;

void printA(int x) { printf("printA: x = %d\r\n", x); }
void printB(int x) { printf("printB: x = %d\r\n", 2*x); }

void getA(int& a) { a = 2; }
void getB(int& a) { a = 5; }

// 関数ポインタの配列
void (*fp4[])(int) =  { printA, printB };
// 関数ポインタの配列（typedef を使う場合）
typedef void (*FP5)(int);
FP5 myFp[] = { printA, printB };

void SwPointer(int k)
{
    printf("\r\nk = %d\r\n", k);

    if (k==0) fp1 = printA;
    else      fp1 = printB;
    fp1(100);
    
    if (k==0) fp2 = getA;
    else      fp2 = getB;
    int x;
    fp2(x);
    printf("nx = %d\r\n", x);

    fp4[k](100);
    myFp[k](10);
}

void MyFunctionPointer()
{
    SwPointer(0);
    SwPointer(1);

    printf("\r\n");
    printf("sin: %f\r\n", fp3Sin(3.1415926536f/3.0f));
    printf("cos: %f\r\n", fp3Cos(3.1415926536f/3.0f));
}
