//------------------------------------------------------------------------------
//  See "https://developer.mbed.org/users/okini3939/notebook/mbed256_memory/"
//
//  このプログラムは，STM 社のマイコンを使用し，mbed ライブラリが
//  リビジョン 153, 172 の場合に有効なことを確認している．それ以外は未確認
//
//  new 演算子でメモリ割り当てに失敗した場合はターミナルに
//  "Operator new[] out of memory" というメッセージが表示される
//
//  割り当てに失敗した段階で上記のメッセージが出てプログラムが終了するので，
//  if 文以下は実行されない．
//
//  set_new_handler() は働いていないようである
//
//  2019/04/10, Copyright (c) 2019 MIKAMI, Naoki
//------------------------------------------------------------------------------
//#include <new>    // set_new_handler() を使う場合でも不要

void MemoryAssignError()
{
    printf("Can't allocate to memory!\r\n");
    while(true);
}

void MyNew()
{
    set_new_handler(MemoryAssignError);
    
    uint8_t *ptr;
//    ptr = new uint8_t[100000];      // OK
    ptr = new uint8_t[1000000];     // 大きすぎて割り当てに失敗する
    
    if (ptr == NULL)
        printf("\r\nMemory allocation error\r\n");
    else
    {
        printf("\r\nptr = 0x%08x\r\n", ptr);
        delete[] ptr;
        printf("正常に終了．\r\n");
    }
}
