// 同じ構造で異なる構造体のコピー

void StructureCopy()
{
    struct myStructA{ int a1; int a2; };
    struct myStructB{ int a1; int a2; };
    
    myStructA x1 = { -1, 17 };
    myStructB y1;
//------------------------------------------------
    y1 = *(myStructB *)&x1;     // ディープ･コピー
//------------------------------------------------
    printf("\r\ny1: %2d, %d\r\n", y1.a1, y1.a2);
    y1.a1 = 2;
    printf("y1: %2d, %d\r\n", y1.a1, y1.a2);
    printf("x1: %2d, %d\r\n", x1.a1, x1.a2);    // x1.a1 は書き換わっていないので
                                                // y1 への代入はシャロ―･コピーではなく
                                                // ディープ･コピーであることが確認できる
    
    // 同じ構造体へのコピー
    myStructB y2;
    y2 = y1;
    printf("\r\ny1: %2d, %d\r\n", y1.a1, y1.a2);
    y2.a1 = 9;
    printf("y1: %2d, %d\r\n", y1.a1, y1.a2);
    printf("y2: %2d, %d\r\n", y2.a1, y2.a2);

    printf("\r\n");
    myStructA u1[] = { {3, 6}, {7, 2}, {6, 1}};
    myStructB *u2;
    u2 = (myStructB *)(&u1);

////    myStructB u2[3];
////    u2 = (myStructB[])((myStructB *)(&u1));
    for (int n=0; n<3; n++)
        printf("%d: %d, %d\r\n", n, u2[n].a1, u2[n].a2);
}