//------------------------------------------------------------
//  使用例：Nucleo と DISCO-746 が対象
//
//  mbed 公式ライブラリリビジョン 153 で OK
//  mbed 公式ライブラリリビジョン 172 で OK
//
//  2019/04/10, Copyright (c) 2019 MIKAMI, Naoki
//------------------------------------------------------------

#include "mbed.h"
#pragma diag_suppress 870       // マルチバイト文字使用の warning 抑制のため

//------------------------------------------------------------------------------
//  以下で，行頭の「//」を削除して有効にした define 文 に対応する処理が実行される
//
//#define MY_MATH                     // 1. 算術関数の例
//#define MY_SORT                     // 2. STL のソートの例
//#define DYNAMIC_POLYMORPHISM        // 3. 実行時ポリモーフィズム
//#define STL_VECTOR                  // 4. STL の vecotr の例
//#define MY_NEW                      // 5. new 演算子のメモリ割り当てエラーを検出の例
//#define FUNCTION_OBJECT             // 6. function object の例
//#define FUNCTION_POINTER            // 7. 関数ポインタの例
//#define FUNCTION_POINTER_IN_CLASS   // 8. クラス内で関数ポインタを使う例
//#define PASS_ARRAY_CONSTRUCTOR      // 9. コンストラクタに渡した Array<> を使う例
//#define REFERENCE_ARRAY             // 10. 異なる型の Array クラスの参照の代入の例
//#define GET_PERIPHERAL_ADDRESS      // 11. ピンの名前に対応するペリフェラルのアドレスを取得
//#define UNION_EXAMPLE               // 12. union の使用例
//#define INITIALIZE_STRUCT           // 13. 構造体の初期化
//#define STRUCT_COPY                 // 14. 同じ構造で異なる構造体のコピー
//#define COMPOOUND_LITERAL           // 15. 複合リテラルの使用例
#define ARRAY_IN_CLASS              // 16. クラス中の Array クラスのオブジェクトの初期化
//
//  有効にすべき define 文はここまで
//------------------------------------------------------------------------------

#include "MyMath.hpp"                   // 1. 算術関数の例
#include "MySort.hpp"                   // 2. STL を使うソートの例
#include "PolyMorphism.hpp"             // 3. 実行時ポリモーフィズム
#include "MyVector.hpp"                 // 4. STL の vecotr の例
#include "MyNew.hpp"                    // 5. new 演算子のメモリ割り当てエラーを検出の例
#include "FunctionObject.hpp"           // 6. function object の例
#include "FunctionPointer.hpp"          // 7. function pointer の例
#include "FunctionPointerInClass.hpp"   // 8. クラス内で関数ポインタを使う例
#include "PassArrayConstructor.hpp"     // 9. コンストラクタに渡した Array<> を使う例
#include "ReferenceArray.hpp"           // 10. 異なる型の Array クラスの参照の代入の例
#include "PeripheralAddress.hpp"        // 11. ピンの名前に対応するペリフェラルのアドレスを取得
#include "UnionExample.hpp"             // 12. union の使用例
#include "InitializeStruct.hpp"         // 13. 構造体の初期化
#include "StructCopy.hpp"               // 14. 同じ構造で異なる構造体のコピー
#include "CompoundLiteral.hpp"          // 15. 複合リテラルの使用例
#include "ArrayExampleInClass.hpp"      // 16. クラス中の Array クラスのオブジェクトの初期化
int main()
{
    printf("\r\n2019/04/10 10:11\r\n");
//------------------------------------------------------------
// 1 : 算術関数の例
#ifdef MY_MATH
    MyMath();
#endif  // MY_MATH

//------------------------------------------------------------
// 2 : STL を使うソートの例
#ifdef MY_SORT
    MySort();
#endif

//------------------------------------------------------------
// 3 : 実行時ポリモーフィズム
#ifdef DYNAMIC_POLYMORPHISM
    MyPolyMorphism();
#endif

//------------------------------------------------------------
// 4 : STL の vecotr の例
#ifdef STL_VECTOR
    MyVector();
#endif

//------------------------------------------------------------
// 5 : new 演算子のメモリ割り当てエラーを検出の例
#ifdef MY_NEW
    MyNew();
#endif

//------------------------------------------------------------
// 6. function object の例
#ifdef FUNCTION_OBJECT
    MyFunctionObject();
#endif
    
//------------------------------------------------------------
// 7. function pointer の例
#ifdef FUNCTION_POINTER
    MyFunctionPointer();
#endif

//------------------------------------------------------------
// 8. クラス内で関数ポインタを使う例
#ifdef FUNCTION_POINTER_IN_CLASS
    MyFunctionPointerClass();
#endif

//------------------------------------------------------------
// 9. コンストラクタに渡した Array<> を使う例
#ifdef PASS_ARRAY_CONSTRUCTOR       
    MyPassArrayConstructor();
#endif

//------------------------------------------------------------
// 10. 異なる型の Array クラスの参照の代入の例
#ifdef REFERENCE_ARRAY
    ReferenceArray();
#endif

//------------------------------------------------------------
// 11. ピンの名前に対応するペリフェラルのアドレスを取得
#ifdef GET_PERIPHERAL_ADDRESS
    PeripheralAddress();
#endif

//------------------------------------------------------------
// 12. union の使用例
#ifdef UNION_EXAMPLE
    UnionExample();
#endif

//------------------------------------------------------------
// 13. 構造体の初期化
#ifdef INITIALIZE_STRUCT
    InitializeStruct();
#endif

//------------------------------------------------------------
// 14. 同じ構造で異なる構造体のコピー
#ifdef STRUCT_COPY
    StructureCopy();    
#endif

//------------------------------------------------------------
// 15. 複合リテラルの使用例
#ifdef COMPOOUND_LITERAL
    CompoundLiteral();
#endif

//------------------------------------------------------------
// 16. クラス中の Array クラスのオブジェクトの初期化
#ifdef ARRAY_IN_CLASS
    ArrayInClass();
#endif

    while (true) {}
}
