//-----------------------------------------------------------------
//  mbed で定義されているピンの名前に対応するペリフェラルのアドレスを取得
//      SPI, TIM, GPIO, ADC の場合
//
//  2017/10/14 修正：mbed rev.153 用に修正
//  2019/04/10 Mbed rev.172 でも問題ないことを確認
//
//  2019/04/10, Copyright (c) 2019 MIKAMI, Naoki
//-----------------------------------------------------------------
//      デバイスは PeripheralPins.h の中で以下のように定義されている
/*
#ifndef MBED_PERIPHERALPINS_H
#define MBED_PERIPHERALPINS_H

#include "pinmap.h"
#include "PeripheralNames.h"

// ADC
extern const PinMap PinMap_ADC[];

// DAC
extern const PinMap PinMap_DAC[];

// I2C
extern const PinMap PinMap_I2C_SDA[];
extern const PinMap PinMap_I2C_SCL[];

// PWM
extern const PinMap PinMap_PWM[];

// SERIAL
extern const PinMap PinMap_UART_TX[];
extern const PinMap PinMap_UART_RX[];
extern const PinMap PinMap_UART_RTS[];
extern const PinMap PinMap_UART_CTS[];

// SPI
extern const PinMap PinMap_SPI_MOSI[];
extern const PinMap PinMap_SPI_MISO[];
extern const PinMap PinMap_SPI_SCLK[];
extern const PinMap PinMap_SPI_SSEL[];

// CAN
extern const PinMap PinMap_CAN_RD[];
extern const PinMap PinMap_CAN_TD[];
*/

//  関数 pinmap_peripheral() は "bitmap.h" の中で定義されている
//------------------------------------------------------------------

#include "mbed.h"
#include "PeripheralPins.h"     // pinmap_peripheral() を使う場合に必要
/*
// この方法は mbed ライブラリの リビジョン 129 からは使えない
class AddressSPI : public SPI
{
public:
    AddressSPI(PinName mosi, PinName miso = NC, PinName sclk = NC)
        : SPI(mosi, miso, sclk) {}
    uint32_t GetAddress() { return _spi.spi; }
};
*/
class AddressSPI
{
public:
    AddressSPI(PinName mosi, PinName miso = NC, PinName sclk = NC)
        : address_(pinmap_peripheral(mosi, PinMap_SPI_MOSI)) {}
    uint32_t GetAddress() { return address_; }
private:
    uint32_t address_;
};


class AddressTIM : public PwmOut
{
public:
    AddressTIM(PinName pin) : PwmOut(pin) {}
    uint32_t GetAddress() { return _pwm.pwm; }
};

class AddressDigitalOut : public DigitalOut
{
public:
    AddressDigitalOut(PinName pin) : DigitalOut(pin) {}
    // 以下は mbed のリビジョン 129 までは問題なかった
//    uint32_t GetAddress() { return (uint32_t)gpio.reg_set_clr & 0xFFFFFF00; }
    // mbed のリビジョン 153 で修正，gpio.reg_set_clr ⇒ gpio.reg_set 
    uint32_t GetAddress() { return (uint32_t)gpio.reg_set & 0xFFFFFF00; }
};

void PeripheralAddress()
{
#if defined(STM32F4)
    AddressSPI x1(D4, NC);
    printf("SPI1/3, D4:    0x%08X\r\n", x1.GetAddress());
    printf("上の表示されるアドレスは SPI1 のもの\r\n");
    printf("SPI,    D4:    0x%08X\r\n", pinmap_peripheral(D4, PinMap_SPI_MOSI));

    // 次の printf() 文のように機能がピン名と異なる場合（D4 は MISO ではない），実行時エラーが
    // ターミナルに表示され，プログラムが終了する
    //printf("SPI3,  D4:    0x%08X\r\n", pinmap_peripheral(D4, PinMap_SPI_MISO));
    SPI mySpi(D4, NC, D3);
    printf("    GPIOB->AFR[0]: 0x%08X\r\n", GPIOB->AFR[0]);
#endif  // STM32F4

//#ifdef __STM32F746xx_H
#ifdef STM32F7
    // PE_6 は DISCO-F746 では使われていない
//    AddressSPI x11(PE_6, NC);
//    printf("SPI,  PE_6:  0x%08X\r\n", x11.GetAddress());
    AddressSPI x11(D7, NC);
    printf("SPI,  D3:    0x%08X\r\n", x11.GetAddress());
#endif  // STM32F7
    
    AddressTIM x2(D12);
    printf("PWM3,   D12:   0x%08X\r\n", x2.GetAddress());
    printf("PWM1,   D8:    0x%08X\r\n", pinmap_peripheral(D8, PinMap_PWM));

    AddressDigitalOut x3(D6);
    printf("GPIOB,  D6:    0x%08X\r\n", x3.GetAddress());

    PinName adc = A0;
    ADCName addresAdc = (ADCName)pinmap_peripheral(adc, PinMap_ADC);
    printf("ADC,   A0:    0x%08X\r\n", addresAdc);
    printf("ADC,   A1:    0x%08X\r\n", pinmap_peripheral(A1, PinMap_ADC));
    printf("ADC,   A2:    0x%08X\r\n", pinmap_peripheral(A2, PinMap_ADC));
}
