
class Func
{
public:
    virtual ~Func() {}
    virtual float operator()(float) = 0;
};

float Integrate(Func &f, float a, float b)
{
    const int N = 1000;
    float step = (b - a)/N;
    float s = 0.0f;
    while(a < b)
    {
        s += f(a)*step;
        a += step;
    }
    return s;
}

float aFunc1(float x) { return x; }
float aFunc2(float x) { return x*x; }

class DerivFunc: public Func
{
public:
    DerivFunc(float (*f)(float)) : f_(f) {}
    virtual float operator()(float d) { return f_(d); }
private:
    float (*f_)(float);
};

void MyFunctionObject()
{
    DerivFunc fx1(aFunc1);
    float area = Integrate(fx1, 0.0, 1.0);  // y = x の 区間 [0, 1] の定積分
    printf("\r\nArea = %f\r\n", area);

    DerivFunc fx2(aFunc2);
    area = Integrate(fx2, 0.0, 1.0);        // y = x*x の 区間 [0, 1] の定積分
    printf("Area = %f\r\n", area);
}
