//-------------------------------------------------------
//  割り込みサービスルーチン (ISR) をクラスの中に作る例
//  Example to define interrupt service routinr (ISR)
//  in class
//
//  2017/07/22, Copyright (c) 2017 MIKAMI, Naoki
//-------------------------------------------------------

#include "mbed.h"

/*
// これでも大丈夫 (OK)
// static メンバ関数を使う方法，Using static member function
class myClass
{
public:
    myClass()
    {
        timer.attach(myClass::AtTime, 1);
    }
private:
    Ticker timer;
    static DigitalOut led1;
    static int flip;
    
    // ISR for Ticker (static function)
    static void AtTime()
    {
        led1 = flip;
        flip = !flip;
    }
};
DigitalOut myClass::led1(LED1);
int myClass::flip = 0;
*/

// myClass の別の書き方 (alternative version)
class myClass
{
public:
    myClass() : led1_(LED1), flip_(0)
    {
        timer_.attach(callback(this, &myClass::AtTime), 0.1f);
    }
private:
    Ticker timer_;
    DigitalOut led1_;
    int flip_;
    
    // ISR for Ticker
    void AtTime()
    {
        led1_ = flip_;
        flip_ = !flip_;
    }
};

int main()
{
    myClass obj;
    
    while (true) {}    
}
