//-----------------------------------------------------------
//  窓関数のライブラリの使用例
//
//  2021/11/10, Copyright (c) 2021 MIKAMI, Naoki
//-----------------------------------------------------------

#include "Hanning.hpp"
#include "Hamming.hpp"
#include "Blackman.hpp"
#include "SerialRxTxIntr.hpp"
using namespace Mikami;
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

int main()
{
    SerialRxTxIntr pc;      // ターミナルとの通信用
    pc.EchobackEnable();    // ターミナルのエコーバック有効
    printf("\r\n窓関数のテスト\r\n");
    
    int nFft, nData;
    do {
        pc.TxString("この窓関数を使う際の FFT の点数を入力してください\r\n? ");
        while(!pc.IsEol()) {}
        nFft = atoi(pc.GetBuffer().c_str());
    } while (nFft == 0);
    do {
        pc.TxString("データ数を入力してください（FFT の点数より大きくない数）\r\n? ");
        while(!pc.IsEol()) {}
        nData = atoi(pc.GetBuffer().c_str());
    } while (nData == 0);

    Array<float> xn(nFft), yn(nFft);
    for (int n=0; n<nFft; n++) xn[n] = 1.0f;

    // FFT の点数とデータ数が違う場合
    BlackmanWindow wBlack(nFft, nData);
    HammingWindow wHamm(nFft,  nData);
    HanningWindow wHann(nFft,  nData);
/*
    // FFT の点数とデータ数が同じ場合
    BlackmanWindow wBlack(nFft);
    HammingWindow wHamm(nFft);
    HanningWindow wHann(nFft);
*/
// ポインタを使う場合の例
//    WindowBase *window = new HammingWindow(nFft, nData);

    while (true)
    {
        printf("窓関数の種類:\r\n");
        printf("ハニング: n, ハミング: m, ブラックマン: b\r\n");
        while(!pc.IsEol()) {}
        char ch = pc.GetBuffer()[0];

        if (ch == 'n')
            { yn = wHann.Execute(xn);  printf("ハニング窓\r\n"); }
        if (ch == 'm')
            { yn = wHamm.Execute(xn);  printf("ハミング窓\r\n"); }
        if (ch == 'b')
            { yn = wBlack.Execute(xn); printf("ブラックマン窓\r\n"); }

// ポインタを使う場合の例
//        yn = window->Execute(xn);
    
        if ((ch == 'n')||(ch == 'm')||(ch == 'b'))
            for (int n=0; n<nFft/8; n++)
            {
                printf("    ");
                for (int k=n*8; k<(n+1)*8; k++) printf("%8.5f,", yn[k]);
                printf("\r\n");
            }
    }
}