//----------------------------------------------------
//  WS2812B クラスの使用例
//
//  2016/11/21, Copyright (c) 2016 MIKAMI, Naoki
//----------------------------------------------------

#include "mbed.h"

#include "ws2812B.hpp"
using namespace Mikami;

//WS2812B myLed_(D11);    // SPI1
//WS2812B myLed_(A4);     // F446RE: SPI2
//WS2812B myLed_(PB_15);  // SPI2
WS2812B myLed_(D4);     // F401RE: SPI1, F446RE: SPI3
//WS2812B myLed_(D4, true);     // SPI3

int main()
{
    // 全部を G + R + B に
    myLed_.Write(0xFFFFFF, 8);  // 全点灯
    wait(1);

    myLed_.Clear(8);            // 全消灯
    wait(1);
    
    // 8 色の点灯
    myLed_.Clear(8);
    myLed_.Write(0x0F0F0F); // G + R + B，強度小
    myLed_.Write(0xFF0000); // G
    myLed_.Write(0x00FF00); // R
    myLed_.Write(0x0000FF); // B
    myLed_.Write(0x00FFFF); // R + B
    myLed_.Write(0xFFFF00); // G + R
    myLed_.Write(0xFF00FF); // G + B
    myLed_.Write(0xFFFFFF); // G + R + B
    wait(1);

    // 全部を R + B に
    myLed_.Write(0x00FFFF, 8); // R + B
    wait(1);

    // 点灯色を順に変化させる
    uint32_t data[] = { 0x0F0F0F, 0xFF0000, 0x00FF00, 0x0000FF,
                        0x00FFFF, 0xFFFF00, 0xFF00FF, 0xFFFFFF};
    int k = 0;
    while (true)
    {
        for (int n=0; n<8; n++)
             myLed_.Write(data[(k+n) & 0x7]);
        k = ++k & 0x07;
        wait(0.5f);
    }
}
