//-------------------------------------------------------------------------
//  SwiManager クラスのデモ･プログラム
//      SWI には CAN2_TX_IRQn を使用
//
//      マイコン･ボードの青色の押しボタン SW 押下の割込みを受け付けると，
//      TeraTerm に表示される数値がインクリメントする
//
//  EXTI15_10_IRQn の優先順位により動作が異なる
//      優先順位 = 0 :  LED1 が点灯中でも押しボタン SW の割込みを受け付ける
//      優先順位 < 0 :  LED1 が点灯中には押しボタン SW の割込みを受け付けず，
//                      消灯してから PbIsr() が実行される
//
//  2020/04/24, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------------------

#include "SwiManager.hpp"
#include "PushButton.hpp"
using namespace Mikami;
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

DigitalOut led_(LED1);      // マイコンボードの LED

void SwiIsr();

SwiManager swi1_(CAN2_TX_IRQn, (uint32_t)SwiIsr, 1);    // 割込み優先順位：1

// PushButton に対応する割込みサービス･ルーチン
void PbIsr()
{
    static int count = 0;
    printf("%d\r\n", count++);
}

// ソフトウェア割込みに対する割込みサービス･ルーチン
void SwiIsr()
{
    led_ = 1;   // LED 点灯
    wait(2);
    led_ = 0;   // LED 消灯
}

// Ticker に対する割込みサービス･ルーチン
void TickerIsr() { swi1_.Invoke(); }
    
int main()
{
    printf("\r\n\nSwiManager の 使用例\r\n");
    printf("マイコン･ボードの LED はプログラム開始 3 秒後から点滅を始めます\r\n");

    // チャタリング防止機能付きの外部入力
    PushButton sw(USER_BUTTON, PullNone, PushButton::FALL, &PbIsr, 0.5);
    NVIC_SetPriority(EXTI15_10_IRQn, 0);    // 割込み優先順位の設定
//    NVIC_SetPriority(EXTI15_10_IRQn, 2);    // 割込み優先順位の設定
    
    printf("割込み優先順位\r\n");
    printf("    EXTI15_10_IRQn: %d\r\n", NVIC_GetPriority(EXTI15_10_IRQn));
    printf("    swi1_         : %d\r\n", swi1_.GetPriority());
    
    Ticker timer;
    timer.attach(&TickerIsr, 3);

    swi1_.Enable();
    while (true) {}
}