//---------------------------------------------------------------------------------
// 出力ポートを，オープンドレインまたはプッシュプルに設定するグローバル関数の使用例
// (Example of global functions for setting the output port bit
//  as open-drain or push-pull)
//
// 2019/12/17, Copyright (c) 2019 MIKAMI, Naoki
//---------------------------------------------------------------------------------

#include "SetOutputPortType.hpp"
using namespace Mikami;

// ユーザ・ボタン（青のボタン）を押すまで待つ関数 
void WaitButton(char str[])
{
    DigitalIn uButton(USER_BUTTON);
    printf(str);
    printf("\r\nPush blue button");
#ifdef STM32F7
    while (uButton != 1) {}
#else
    while (uButton == 1) {}
#endif
    wait(0.5);
}

int main()
{
    BusOut bus(D2, D3, D4, D5, D6, D7, D8);

// MODER    I/O ポートを，入力/汎用出力/代替え機能/アナログに設定するレジスタ
// PUPDR    I/O ポートを，プルアップ，プルダウン，プルアップ･プルダウンなしに設定するレジスタ
// OTYPER   出力のタイプをプッシュプル/オープンドレインに設定するレジスタ
    printf("\r\n\nGPIOB mode Reg.: 0x%08x", GPIOB->MODER);
    printf("\r\nGPIOB pull-up/pull-down Reg.: 0x%08x", GPIOB->PUPDR);
    
    bus = 0x7F;
    SetOpenDrain(D2, D3, D4, D5, D6, D7, D8);
    printf("\r\n\nGPIOB output type Reg.: 0x%04x", GPIOB->OTYPER);
    printf("\r\nGPIOA output type Reg.: 0x%04x", GPIOA->OTYPER);
    WaitButton("\r\nD2 - D8: open drain\r\n");
    
    SetPushPull(D2, D3, D4, D5, D6, D7, D8);
    printf("\r\nGPIOB output type Reg.: 0x%04x", GPIOB->OTYPER);
    printf("\r\nGPIOA output type Reg.: 0x%04x", GPIOA->OTYPER);
    WaitButton("\r\nD2 - D8: push-pull\r\n");

    SetOpenDrain(D2);
    printf("\r\nGPIOB output type Reg.: 0x%04x", GPIOB->OTYPER);
    printf("\r\nGPIOA output type Reg.: 0x%04x", GPIOA->OTYPER);
    WaitButton("\r\nD2: open drain\r\n");
    
    SetOpenDrain(D3, D4);
    printf("\r\nGPIOB output type Reg.: 0x%04x", GPIOB->OTYPER);
    printf("\r\nGPIOA output type Reg.: 0x%04x", GPIOA->OTYPER);
    printf("\r\nD2 - D4: open drain\r\n");
    
#ifdef STM32F7
    DigitalOut pg(PG_0, 0);
    WaitButton("\r\nPG_0: push-pull, Output: 0\r\n");
    
    pg = 1;
    WaitButton("\r\nPG_0: push-pull, Output: 1\r\n");
    SetOpenDrain(PG_0);
    
    WaitButton("\r\nPG_0: Open RDain\r\n");
    SetPushPull(PG_0);
    WaitButton("\r\nPG_0: push-pull\r\n");
#endif
    
    printf("\r\nEnd of Test\r\n");

    while (true);
}
