//----------------------------------------------------------------
//  押しボタンスイッチのチャタリング防止付き InterruptIn の使用例
//      押しボタンスイッチ: D6 に接続
//
//  2020/04/21, Copyright (c) 2020 MIKAMI, Naoki
//----------------------------------------------------------------

#include "PushButton.hpp"
using namespace Mikami;
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

// PushButton に対応する割込みサービス･ルーチン
void Isr()
{
    static int n = 0;
	printf("%d\r\n", n++);
}

int main()
{
    printf("\r\n\nチャタリング防止付き InterruptIn の使用例\r\n");
    printf("スイッチを押すたびにターミナルに表示される数値が１づつ増加します\r\n");
    Isr();

	// 0.2 秒間はスイッチ入力を受け付けないような初期設定の例
    PushButton sw(D6, PullDown, PushButton::RISE, &Isr, 0.2);

    while (true) {}
}