//--------------------------------------------------------------
//  SD カード書き込み，読み出しの例
//      インターフェース：SPI モード使用
//
//  このプログラムが STM32F446RE で動作するライブラリのリビジョン：
//      SDFileSystem      3,      4 ～ 6 では正常に動かない
//      FATFileSystem     3,      4 ～ 9 では正常に動かない
//      mbed            121,    122 ～ 128 では正常に動かない
//  調べた時点での mbed ライブラリの最新版：128
//
//  fprintf() で，文字列に日本語を使っているため，コンパイル時に
//  警告が出るが，無視しても問題はない
//
//  2016/11/13, 三上 直樹
//--------------------------------------------------------------

#include "mbed.h"
#include "SDFileSystem.h"

//SDFileSystem sd_(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCK, CS: SPI1
SDFileSystem sd_(D4, D5, D3, D2, "sd");     // MOSI, MISO, SCK, CS: SPI3
Serial pc_(USBTX, USBRX);

int main() {
    pc_.baud(9600);
    pc_.printf("\r\nInitializing\r\n");

    // 書き込みのテスト
    pc_.printf("\nWriting to SD card...: ");
    FILE *fp = fopen("/sd/sdtest.txt", "a+");   // 追加書き込み
    
    if (fp != NULL)
    {
        fprintf(fp, "SD カードのテストです．\r\n");
        fclose(fp);
        pc_.printf("success!\r\n");
    }
    else
        pc_.printf("failed!\r\n");
 
    // 読み出しのテスト
    pc_.printf("Reading from SD card...:\r\n");
    fp = fopen("/sd/sdtest.txt", "r");
    if (fp != NULL)
    {
        char str[256];
        while (fgets(str, 256, fp) != NULL)
            pc_.printf("%s", str);
        
        fclose(fp);
        pc_.printf("success!\r\n");
    }
    else
        pc_.printf("failed!\r\n");
 
    while (true) {}
}
