//-----------------------------------------------------------
// MyTicker7 クラスの使用例
//
//  2020/10/17, Copyright (c) 2020 MIKAMI, Naoki
//-----------------------------------------------------------

#include "MyTicker7.hpp"
using namespace Mikami;
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

//#define NONE_INTERRUPT  // 割込みを使わない場合はこの define 文を有効にする

#ifdef NONE_INTERRUPT
// 割込みを使わない場合
int main()
{
    printf("\r\nMyTicker7 の使用例（割込みを使わない場合）\r\n");
    MyTicker7 tim(0.5);  // 出力間隔： 0.5 μs
    // 出力間隔の上限： 182.04442 μs
    //MyTicker7 tim(182.04442);  // 出力間隔： 182.04442 μs
    
    DigitalOut dOut(D2, 1);
    
    while (true)
    {
        tim.Sync();
        dOut = !dOut;
    }
}

#else
// 割込みを使う場合
DigitalOut dOut_(D2, 1);

void TimerIsr() { dOut_ = !dOut_; }

int main()
{
    printf("\r\nMyTicker7 の使用例（割込みを使う場合）\r\n");
    MyTicker7 tim(0.5);  // 出力間隔： 0.5 μs
    tim.Attach(&TimerIsr);
    
    while (true) {}
}
#endif