//------------------------------------------------------------------------------
//  IirCascade クラスの使用例（低域通過フィルタ）
//  Example for IirCascade class (lowpass filter)
//  2015/09/11, Copyright (c) 2015 MIKAMI, Naoki
//------------------------------------------------------------------------------

#include "ADC_BuiltIn.hpp"
#include "DAC_MCP4922.hpp"

#include "IIR_Cascade.hpp"
#include "Coefficients.hpp"     // Coeffisients for the IIR filter

using namespace Mikami;         // must be declared

const int FS_ = 16000;          // sampling frequency: 10 kHz
ADC_BuiltIn adc_(A0, FS_);      // for A0 of built-in ADC
DAC_MCP4922 myDac_;             // for external DAC
DigitalIn sw_(D2, PullDown);    // for rotary dip switch

// Object for lowpass filter
IirCascade<ORDER_> lpf_(g0_, ck_);

int main()
{
    myDac_.ScfClockTim3(700000);    // cutoff frequency of smoothing LPF: 7 kHz

    lpf_.Clear();   // clear internal buffer in lowpass filter
  
    while (true)
    {
        float xn = adc_.Read();         // read input signal
        //-----------------------------------------------

        float yn = lpf_.Execute(xn);    // execute LPF
        
        //-----------------------------------------------
        if (sw_ == 0) myDac_.Write(xn); // through
        else          myDac_.Write(yn); // filtered output
    }
}

