//--------------------------------------------------------------
//  Coefficients for lowpass filter
//--------------------------------------------------------------
#include "Biquad.hpp"
using namespace Mikami;

// lowpass elliptic filter
// order                     8
// sampling frequency       16.00 kHz
// cutoff frequency          0.40 kHz
// pass band ripple          0.50 dB
// stop band attenuation    40.00 dB
const int ORDER_ = 8;   // order
const Biquad::Coefs ck_[ORDER_/2] = {
    {  1.883738E+00f, -8.905325E-01f, -1.786844E+00f, 1.0f},    // 1段目
    {  1.936883E+00f, -9.545132E-01f, -1.958707E+00f, 1.0f},    // 2段目
    {  1.964116E+00f, -9.872477E-01f, -1.971373E+00f, 1.0f},    // 3段目
    {  1.972835E+00f, -9.975120E-01f, -1.973698E+00f, 1.0f} };  // 4段目
const float g0_ = 9.739748E-03f;        // gain factor
