//--------------------------------------------------------------
//	離散的フーリエ変換 (DFT)
//
//  2020/12/12, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"
#include <complex>  // complex で使用

#ifndef DFT_REAL_HPP
#define DFT_REAL_HPP

typedef complex<float> Complex;     // "Complex" の定義

void DftReal(const float x[], Complex y[], int nFft);

//  DFT の計算
void DftReal(const float x[], Complex y[], int nFft)
{
    Complex j2PiN = Complex(0, -6.28318531f/nFft);

    for (int k=0; k<nFft; k++)
    {
        y[k] = 0.0;
        for (int n=0; n<nFft; n++)
            y[k] = y[k] + x[n]*exp(j2PiN*(float)(n*k));
    }
}
#endif	// DFT_REAL_HPP