//--------------------------------------------------------------
//  FftReal クラスのデモ用プログラム
//
//  2020/12/12, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------------

#include "dftReal.hpp"
#include "fftReal.hpp"
using namespace Mikami;
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

int main()
{
    const int N = 16;       // FFT のデータ数
//    const int N = 256;       // FFT のデータ数

    float x1[N], x2[N];
    Complex y1[N], y2[N/2+1];

    // 乱数生成
    srand(1234);
    for (int n=0; n<N; n++)
        x1[n] = 2.0f*rand()/(float)RAND_MAX - 1.0f;
    printf("\r\n#### 元のデータ ####\r\n");
    for (int n=0; n<N; n++)
        printf("f[%2d]: %8.4f\r\n", n, x1[n]);

    Timer tm;   // 実行時間測定のため

    // DFT, 比較のため
    tm.reset();
    tm.start();
    DftReal(x1, y1, N);
    tm.stop();
    printf("\r\n実行時間 (DFT): %d [μs]\r\n", tm.read_us());

    // FFT
    FftReal fft(N);
    tm.reset();
    tm.start();
    fft.Execute(x1, y2);
    tm.stop();
    printf("実行時間 (FFT): %d [μs]\r\n", tm.read_us());

    printf("\r\n#### DFT と FFT による結果 ####\r\n");
    printf("          実部      虚部      実部      虚部\r\n");
    for (int n=0; n<=N/2; n++)
        printf("F[%2d]: %8.4f, %8.4f; %8.4f, %8.4f\r\n",
               n, y1[n].real(), y1[n].imag(), y2[n].real(), y2[n].imag());
    
    // IFFT
    tm.reset();
    tm.start();
    fft.ExecuteIfft(y2, x2);
    tm.stop();
    printf("\r\n実行時間 (IFFT): %d [μs]\r\n", tm.read_us());
    printf("\r\n#### IFFT の結果 ####\r\n");
    printf("        元の値    FFT の IFFT\r\n");
    for (int n=0; n<N; n++)
        printf("f[%2d]: %8.4f, %8.4f\r\n", n, x1[n], x2[n]);
}