//----------------------------------------------------------------------
//  NUCLEO-F446 で STM32F446 内蔵の ADC, DAC のためのクラスのデモプログラム
//      使用するクラス：AdcSingle, DacSingle, AdcSingleIntr
//      処理の内容：AD 変換器からの入力をそのまま DA 変換器に出力する
//      ポーリング方式と割り込み方式の２つの例を示す
//
//  2017/02/21, Copyright (c) 2017 MIKAMI, Naoki
//----------------------------------------------------------------------

// 割り込みの例を有効にする場合，次の #define 文を有効にすること
//#define ADC_EXAMPLE_OF_INTERRUPT

//----------------------------------------------------------------------
// ポーリングを使う例
#ifndef ADC_EXAMPLE_OF_INTERRUPT
#include "F446_ADC_Single.hpp"
using namespace Mikami;

int main()
{
    const int FS = 10000;       // Sampling frequency: 10 kHz
    AdcSingle myAdc(A0, FS);    // See "F446_ADC_Single.hpp"
    DacSingle myDac;            // See "F446_DAC_Single.hpp"
    myDac.ScfClock(420000);     // 出力の LPF の遮断周波数を 4.2 kHz に設定

    printf("\r\nUsing polling\r\n");
    while (true)
    {
/*
        // float 型の例
        float sn = myAdc.Read();
*/

        // uint16_t 型の例
        uint16_t sn = myAdc.ReadUint();

        myDac.Write(sn);
    }
}

//----------------------------------------------------------------------
// ADC 変換終了割り込みを使う例
#else
#include "F446_ADC_Interrupt_Single.hpp"
using namespace Mikami;

const int FS_ = 10000;          // Sampling frequency: 10 kHz
AdcSingle_Intr myAdc_(A1, FS_); // See "F446_ADC_Interrupt_Single.hpp"
DacSingle myDac_;               // See "F446_DAC_Single.hpp"

// ADC 変換終了割り込みに対する割り込みサービス･ルーチン
void AdcIsr()
{
    float sn = myAdc_.Read();
    myDac_.Write(sn);
}

int main()
{
    printf("\r\nUsing interrupt\r\n");

    myDac_.ScfClock(420000);    // 出力の LPF の遮断周波数を 4.2 kHz に設定
    // ADC 変換終了割り込みに対する割り込みサービス･ルーチンを割り当てる
    myAdc_.SetIntrVec(&AdcIsr);

    uint32_t n = 0;
    while (true)
    {
        printf("%d\r\n", n++);
        wait(1);
    }
}
#endif
