//----------------------------------------------------------------------
//  NUCLEO-F446RE で アナログ信号の入出力の際に，出力の標本化周波数を，
//  入力の標本化周波数の４倍にするクラス F446_MultirateSWI の使用例
//
//  処理の内容：AD 変換器からの入力をそのまま DA 変換器に出力する
//
//  2018/11/28, Copyright (c) 2018 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "F446_MultirateSWI.hpp"
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

using namespace Mikami;

F446_MultirateSWI myAdDa_;  // 出力標本化周波数を４倍にするオブジェクト

// ここにディジタルフィルタ等の処理を記述する（割り込みサービス･ルーチン）
void SignalProcessing()
{
    float xn = myAdDa_.Input(); // 入力
//    wait_us(93);                // 標本化周波数が 10 kHz の場合，
                                // 93 μs 以下の実行時間の信号処理であれば OK
    float yn = xn;              // これは入力信号に何も処理しない例
    myAdDa_.Output(yn);         // 出力
}

int main()
{
    const int FS = 10000;   // 入力の標本化周波数： 10 kHz
    printf("\r\n開始します．\r\n");

    myAdDa_.Start(FS, &SignalProcessing);   // 標本化を開始する

    while (true) {}
}