//--------------------------------------------------------------------------
//  NUCLEO-F446RE で アナログ信号の入出力の際に，出力の標本化周波数を，
//  入力の標本化周波数の４倍にするクラス F446_LinearPhase の使用例
//
//  F446_LinearPhase クラスでは出力の補間フィルタとして直線位相 FIR フィルタを使用
//
//  処理の内容：AD 変換器からの入力をそのまま DA 変換器に出力する
//
//  2018/11/28, Copyright (c) 2018 MIKAMI, Naoki
//--------------------------------------------------------------------------

#include "F446_LinearPhase.hpp"
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため
#include "coefficients.hpp" // 補間フィルタとしてデフォルト以外のものを使う場合

using namespace Mikami;

const int FS_ = 10000;      // 入力の標本化周波数： 10 kHz

// 出力標本化周波数を４倍にするオブジェクト，デフォルトの補間用フィルタを使う場合
F446_LinearPhase myAdDa_;

// 第一引数を 0 にすると，出力の際に補間処理は行われない
//F446_LinearPhase myAdDa_(0);

// 出力標本化周波数を４倍にするオブジェクト，デフォルト以外の補間用フィルタを使う場合
//F446_LinearPhase myAdDa_(ORDER_, HK1_, HK2_, HK3_);
   
int main()
{
    printf("\r\n開始します．\r\n");

    myAdDa_.Start(FS_);         // 標本化を開始する

    while (true)
    {
        //------------------------------------------------------------
        // ここにディジタルフィルタ等の処理を記述する
        float xn = myAdDa_.Input(); // 入力
//        wait_us(92);                // 標本化周波数が 10 kHz で，
                                    // デフォルトの補間用フィルタを使う場合，
                                    // 92 μs 以下の実行時間の信号処理であれば OK
//        wait_us(90);                // 補間用フィルタとして 96 次のフィルタを使う場合．
                                    // 90 μs 以下の実行時間の信号処理であれば OK
        float yn = xn;              // これは入力信号に何も処理しない例
        myAdDa_.Output(yn);         // 出力
        //------------------------------------------------------------
    }
}
