//----------------------------------------------------------------------
//  NUCLEO-F446RE で アナログ信号の入出力の際に，出力の標本化周波数を，
//  入力の標本化周波数の４倍にするクラス F446_Multirate の使用例
//
//  処理の内容：AD 変換器からの入力をそのまま DA 変換器に出力する
//
//  2018/11/28, Copyright (c) 2018 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "F446_Multirate.hpp"
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

using namespace Mikami;

int main()
{
    const int FS = 10000;   // 入力の標本化周波数： 10 kHz
    F446_Multirate myAdDa;  // 出力標本化周波数を４倍にするオブジェクト
    printf("\r\n開始します．\r\n");

    // F446_Multirate::Start() と F446_Multirate::Input() の間に
    // printf() のように重い処理は実行しないこと．
    myAdDa.Start(FS);       // 標本化を開始する

    while (true)
    {
        //------------------------------------------------------------
        // ここにディジタルフィルタ等の処理を記述する
        float xn = myAdDa.Input();  // 入力
//        wait_us(93);                // 標本化周波数が 10 kHz の場合，
                                    // 93 μs 以下の実行時間の信号処理であれば OK
        float yn = xn;              // これは入力信号に何も処理しない例
        myAdDa.Output(yn);          // 出力
        //------------------------------------------------------------
    }
}
