//----------------------------------------------------------------------
//  NUCLEO-F446 で STM32F446 内蔵の ADC, DAC のためのクラスのデモプログラム
//      使用するクラス：AdcDual, DacDual, AdcDualIntr
//      処理の内容：AD 変換器からの入力をそのまま DA 変換器に出力する
//      ポーリング方式と割り込み方式の２つの例を示す
//
//  2017/02/19, Copyright (c) 2017 MIKAMI, Naoki
//----------------------------------------------------------------------

// 割り込みの例を有効にする場合，次の #define 文を有効にすること
//#define ADC_EXAMPLE_OF_INTERRUPT

//----------------------------------------------------------------
// ポーリングを使う例
#ifndef ADC_EXAMPLE_OF_INTERRUPT
#include "F446_ADC.hpp"
using namespace Mikami;

int main()
{
    const int FS = 10000;       // Sampling frequency: 10 kHz
    AdcDual myAdc(FS);          // See "F446_ADC.hpp"
    DacDual myDac;              // See "F446_DAC.hpp"
    myDac.ScfClock(420000);     // 出力の LPF の遮断周波数を 4.2 kHz に設定

    printf("\r\nUsing polling\r\n");
    while (true)
    {
        // float 型の例
        float sn1, sn2;
        myAdc.Read(sn1, sn2);
/*
        // uint16_t 型の例
        uint16_t sn1, sn2;
        myAdc.Read(sn1, sn2);
*/
        myDac.Write(sn1, sn2);
    }
}

//----------------------------------------------------------------
// ADC 変換終了割り込みを使う例
#else
#include "F446_ADC_Interrupt.hpp"
using namespace Mikami;

const int FS_ = 10000;      // Sampling frequency: 10 kHz
AdcDual_Intr myAdc_(FS_);   // See "F446_ADC_Interrupt.hpp"
DacDual myDac_;             // See "F446_DAC.hpp"

// ADC 変換終了割り込みに対する割り込みサービス･ルーチン
void AdcIsr()
{
    float sn1, sn2;
    myAdc_.Read(sn1, sn2);
    myDac_.Write(sn1, sn2);
}

int main()
{
    printf("\r\nUsing interrupt\r\n");

    myDac_.ScfClock(420000);    // 出力の LPF の遮断周波数を 4.2 kHz に設定
    // ADC 変換終了割り込みに対する割り込みサービス･ルーチンを割り当てる
    myAdc_.SetIntrVec(&AdcIsr);

    uint32_t n = 0;
    while (true)
    {
        printf("%d\r\n", n++);
        wait(1);
    }
}
#endif
