//-----------------------------------------------------------------------------
//  USB メモリの読み書きの例（Nucleo-F401RE/F446RE で確認済み）
//
//  このプログラムのオリジナルは，Norimasa Okamoto 氏が作成したもので，下記のサイト
//  よりインポートした．
//
//  https://developer.mbed.org/users/va009039/code/F401RE-USBHostMSD_HelloWorld/
//
//  このプログラムの中で，USB メモリを扱う場合には使わないと思われるファイルは消去した．
//  さらに，mbed のライブラリをリビジョン 127 にアップデートした際に発生したコンパイル･
//  エラーを修正した．
//  ただし，2016/10/08 の時点では，コンパイルの際のいくつかの警告についてははそのままに
//  になっている．
//
//  USB に対応するポート（PA11, PA12）は "USBHALHost_F401RE.cpp" で定義されている．
//  接続方法：
//      ST morpho           USB
//      U5V   (CN10-8)      VBUS (1 RED)
//      PA_11 (CN10-14)     D-   (2 WHITE)
//      PA_12 (CN10-10)     D+   (3 GREEN)
//      GND   (CN10-20)     GND  (4 BLACK, TYPE A, または 5 mini/micro B)
//
//  2016/11/13, 三上 直樹
//-----------------------------------------------------------------------------

#include "USBHostMSD.h"

DigitalOut led1(LED1);

int main()
{
    USBHostMSD msd("usb");
    if (!msd.connect())
        error("USB Flash drive not found.\n");

//    FILE* fp = fopen("/usb/test1.txt", "a");  // オリジナルは "a"
    FILE* fp = fopen("/usb/test1.txt", "w");
    if (fp)
    {
        fprintf(fp, "Hello from mbed.\r\n");
        for(int i = 0; i < 21; i++)
            {
                fprintf(fp, " %d", i);
                led1 = !led1;
            }
        fprintf(fp, "\n");
        fclose(fp);
    }
    fp = fopen("/usb/test1.txt", "r");
    if (fp)
    {
        int n = 0;
        while (true)
        {
            int c = fgetc(fp);
            if (c == EOF) break;

            printf("%c", c);
            n++;
            led1 = !led1;
        }
        fclose(fp);
        printf("\r\n%d bytes\r\n", n);
    }

    while (true)
    {
        led1 = !led1;
        wait_ms(200);
    }
}
