//-------------------------------------------------------------
// DigitalOutEx クラスの使用例（赤色 LED をオープンドレインで駆動する）
//      
//      LED のアノード側: 5 V
//      LED のカソード側: D8（または他の出力ポート）
//
//      初期状態はオープンドレインに設定するが，count > 10 に
//      なったらプッシュプル出力に設定しなおす
//
//  2018/09/29, Copyright (c) 2016 MIKAMI, Naoki
//-------------------------------------------------------------

#include "DigitalOutEx.hpp"
using namespace Mikami;

// デフォルトはオープンドレインに設定される
DigitalOutEx ledR_(D8);     // PA_9, LED のカソード側をこの端子につなぐ
//DigitalOutEx ledR_(D8, DigitalOutEx::PushPull);     // PA_9
//DigitalOutEx ledR_(D6);     // PB_10
//DigitalOutEx ledR_(A4, 1);  // PC_1
//DigitalOutEx ledR_(PD_2);   // OK 
//DigitalOutEx ledR_(PE_14);  // OK, F746ZG
//DigitalOutEx ledR_(PF_9);   // OK, F746ZG
//DigitalOutEx ledR_(PG_0);   // OK, F746ZG

int main()
{
    int count = 0;
    while(true)
    {
        ledR_ = !ledR_;   // 前の状態の逆にする
        wait(1);
        if (++count > 10) ledR_.SetPushPull();  // プッシュプル出力に設定
    }
}
