//------------------------------------------------------------------
//  補間に使うフィルタの係数としてデフォルト以外の係数を使う場合の定義の例
//
//  デフォルトの係数を使う場合は，このファイルは不要
//
//  このファイルを使ってデフォルト以外の係数を使う場合は，以下のいずれかの
//  #define 文を，このファイルをインクルードする前に記述すること
//      #define FIR_INTERPOLATOR_ORDER94
//      #define FIR_INTERPOLATOR_ORDER2
//
//  2021/12/22, Copyright (c) 2021 MIKAMI, Naoki
//------------------------------------------------------------------

#ifdef FIR_INTERPOLATOR_ORDER94
// 使用窓関数   Kaiser 窓
// 標本化周波数 (kHz)      40.000000
// 次数                    94
// 種類         LPF
// 遮断周波数 (kHz)         5.000000
// 減衰量 (dB)             40.00 
const int ORDER_ = 94;
const float HK1_[] = {
    -2.834375E-03f,  4.733192E-03f, -7.242540E-03f,  1.050347E-02f,
    -1.471384E-02f,  2.017552E-02f, -2.739185E-02f,  3.728930E-02f,
    -5.179396E-02f,  7.566552E-02f, -1.246163E-01f,  2.983749E-01f,
     8.997384E-01f, -1.771898E-01f,  9.493016E-02f, -6.203116E-02f,
     4.377384E-02f, -3.191974E-02f,  2.352042E-02f, -1.726323E-02f,
     1.247434E-02f, -8.768420E-03f,  5.903704E-03f, -3.714820E-03f};
const float HK2_[] = {
    -4.607768E-03f,  7.493168E-03f, -1.128657E-02f,  1.620341E-02f,
    -2.255220E-02f,  3.081388E-02f, -4.180948E-02f,  5.709228E-02f,
    -8.001272E-02f,  1.193378E-01f, -2.073427E-01f,  6.349864E-01f,
     6.349864E-01f, -2.073427E-01f,  1.193378E-01f, -8.001272E-02f,
     5.709228E-02f, -4.180948E-02f,  3.081388E-02f, -2.255220E-02f,
     1.620341E-02f, -1.128657E-02f,  7.493168E-03f, -4.607768E-03f};
const float HK3_[] = {
    -3.714820E-03f,  5.903704E-03f, -8.768420E-03f,  1.247434E-02f,
    -1.726323E-02f,  2.352042E-02f, -3.191974E-02f,  4.377384E-02f,
    -6.203116E-02f,  9.493016E-02f, -1.771898E-01f,  8.997384E-01f,
     2.983749E-01f, -1.246163E-01f,  7.566552E-02f, -5.179396E-02f,
     3.728930E-02f, -2.739185E-02f,  2.017552E-02f, -1.471384E-02f,
     1.050347E-02f, -7.242540E-03f,  4.733192E-03f, -2.834375E-03f};
#endif  // FIR_INTERPOLATOR_ORDER94

#ifdef FIR_INTERPOLATOR_ORDER4
// 以下は，出力の際の補間を行わない場合に相当する信号を出力したい場合に使う
const int ORDER_ = 2; 
const float HK1_[] = {1};
const float HK2_[] = {1};
const float HK3_[] = {1};
#endif  // FIR_INTERPOLATOR_ORDER2