//----------------------------------------------------------------------
//  STM32F446 内蔵の ADC, DAC のためのクラスのデモプログラム
//      使用するクラス：DspAdc_Polling, DspAdc_Intr, DspDac
//      処理の内容：AD 変換器からの入力をそのまま DA 変換器に出力する
//
//      ポーリング方式と割込み方式の２つの例を示す
//
//  2020/12/20, Copyright (c) 2020 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "DSP_Dac.hpp"      // DAC 用
using namespace Mikami;
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

const float FS_ = 100;      // 標本化周波数: 100 kHz
DspDac myDac_;              // DA 変換器, 出力端子: A2（デフォルト）

// 割込みの例を有効にする場合，次の #define 文を有効にすること
//#define ADC_EXAMPLE_OF_INTERRUPT

//----------------------------------------------------------------
// ポーリングを使う例
#ifndef ADC_EXAMPLE_OF_INTERRUPT
#include "DSP_AdcPolling.hpp"

int main()
{
    DspAdcPolling myAdc(FS_, A1);   // AD 変換器, ADC2使用（デフォルト）
    printf("\r\nポーリング方式\r\n");

    while (true)
    {
        float sn = myAdc.Read();
        myDac_.Write(sn);
    }
}

//----------------------------------------------------------------
// ADC 変換終了割込みを使う例
#else
#include "DSP_AdcIntr.hpp"

DspAdcIntr myAdc_(FS_, A1);     // AD 変換器, ADC2使用（デフォルト）

// ADC 変換終了割込みに対する割込みサービス･ルーチン
void AdcIsr()
{
    float sn = myAdc_.Read();
    myDac_.Write(sn);
}

int main()
{
    printf("\r\n割込み方式\r\n");

    // ADC 変換終了割込みに対する割込みサービス･ルーチンを割り当てる
    myAdc_.SetIntrVec(&AdcIsr);

    uint32_t n = 0;
    while (true)
    {
        printf("%d\r\n", n++);
        wait(1);
    }
}
#endif