//------------------------------------------------------------
//  Demo program for Array class and Matrix class
//
//  2020/12/19, Copyright (c) 2016 MIKAMI, Naoki
//------------------------------------------------------------

#define DEBUG_ARRAY_CHECK   // Range check of index available

#include "Matrix.hpp"
#include <string>

using namespace Mikami;
void PrintMatrix(const char str[], const Matrix<int> &x);

void Square(Array<float> & x);
void Sqrt(float x[], int N);

int main()
{
    // Test of Array class
    Array<int> sn(10);
    sn[9] = 0;
//    sn[10] = 0;   // Out of range error
    
//    Array<uint8_t> a1(1000000);  // Size error (Nucleo-F446RE)
    Array<uint8_t> a1(10000);
    printf("\r\nMemory allocation: OK\r\n");
    
    const int N1 = 10;
    Array<float> x1(N1), x2, x3;
    for (int n=0; n<N1; n++) x1[n] = n;
    x3 = x2 = x1;
    
    Square(x2);
    Sqrt(x3, N1);
    for (int n=0; n<N1; n++)
        printf("%8.4f, %8.4f, %8.4f\r\n", x1[n], x2[n], x3[n]);
    printf("\r\n");
    
    // Initialization by built-in array
    Array<int> xInt(5, (int[]){ 4, 1, -3, 9, -5});
    for (int n=0; n<xInt.Length(); n++)
        printf("xInt[%d] = %d\r\n", n, xInt[n]);
    
    // Test of Matrix class
    Matrix<int> mat1(3, 2), mat2;
    for (int n2=0; n2<mat1.Cols(); n2++)
        for (int n1=0; n1<mat1.Rows(); n1++)
            mat1[n1][n2] = n2*mat1.Rows() + n1;
    mat2 = mat1;

    PrintMatrix("mat2:", mat2);

    Matrix<int> mat3(5, 2, 10);
    PrintMatrix("mat3: Initialized valeus", mat3);
    
    mat3.Fill(5);
    PrintMatrix("mat3: Updated valeus", mat3);
    
    while (true) {}
}

void Square(Array<float> & x)
{   for (int n=0; n<x.Length(); n++) x[n] = x[n]*x[n]; }

void Sqrt(float x[], int N)
{   for (int n=0; n<N; n++) x[n] = sqrtf(x[n]); }

void PrintMatrix(const char str[], const Matrix<int> &x)
{
    printf("%s\r\n", str);
    for (int n2=0; n2<x.Cols(); n2++)
    {
        for (int n1=0; n1<x.Rows(); n1++)
            printf("%3d", x[n1][n2]);
        printf("\r\n");
    }
}