//------------------------------------------------------------------------
//  LCD 表示器 AQM1602 用クラスライブラリ Aqm1602 の使用例
//
//  動作を確認したボード： Nucleo-F401RE, Nucleo-F411RE, Nucleo-F446RE,
//                         LPC1768
//  動作が不良なボード：   Nucleo-F302R8, Nucle0-F746ZG, Disco-f746NG
//
//  使用した mbed ライブラリ：        Rev.172
//  使用した Aqm1602 用ライブラリ：   Rev.15
//
// 2020/04/16, Copyright (c) 2020 MIKAMI, Naoki
//------------------------------------------------------------------------

#pragma diag_suppress 870   // マルチバイト文字使用の警告を出ないようにする
#include "AQM1602.hpp"

// タイマ割り込みを使う場合は，次の define 文をコメントアウトする
//#define WITHOUT_TIMER_INTERRUPT

using Mikami::Aqm1602;
// 以下は Nucleo の場合
Aqm1602 lcd_;   // OK, Default, D14: SDA, D15: SCL
//Aqm1602 lcd_(D14, D15, 200000, true, true);   // OK
//Aqm1602 lcd_(PB_4, PA_8);   // OK, PB_4: D5, PA_8: D7

// 以下は Nucleo を使い，既に生成された I2C のオブジェクトを渡す場合
//I2C i2cObj_(D14, D15);                         
//Aqm1602 lcd_(i2cObj_);      // OK

// 以下は LPC1768 の場合
//Aqm1602 lcd_(p9, p10);      // OK

#ifdef WITHOUT_TIMER_INTERRUPT
//------------------------------------------------------------------------------
// タイマ割り込みを使わない場合
int main()
{
    if (lcd_.IsConnected()) printf("\r\nLCD が接続されています．\r\n");
    else                    printf("\r\nLCD が接続されていません．\r\n");

    lcd_.Clear();
    lcd_.WriteString("Using Wait");

    int count = 0;
    while (true)
    {
        lcd_.WriteValueXY("%d", count, 0, 1);
        printf("%d\r\n", count++);
        wait(1);    // ここで１秒間待つ
    }
}

#else
//------------------------------------------------------------------------------
// タイマ割り込みを使う場合
Ticker timer_;

// タイマ割り込みに対する割り込みサービスルーチン
void TimerIsr()
{
    static int count = 0;
    lcd_.WriteValueXY("%d", count, 0, 1);
    printf("%d\r\n", count++);
}

int main()
{
    if (lcd_.IsConnected()) printf("\r\nLCD は接続されています．\r\n");
    else                    printf("\r\nLCD は接続されていません．\r\n");

    lcd_.Clear();
    lcd_.WriteString("Using Ticker");

    TimerIsr();     // 直ちに "0" を表示するため
    timer_.attach(&TimerIsr, 1);
    while (true) {}
}
#endif