//------------------------------------------------------------
// Test program for LCD AQM0802A using I2C interface
//      Pullup resistors for SDA and SCL: 10 kΩ
// 2014/12/21, Copyright (c) 2014 MIKAMI, Naoki
//------------------------------------------------------------

#include "mbed.h"
#include "AQM0802_I2C.hpp"
using namespace Mikami;

Aqm0802A lcd_;                                  // Default, OK
//Aqm0802A lcd_(D14, D15);                        // OK
//Aqm0802A lcd_(D14, D15, 200000);                // OK
//Aqm0802A lcd_(D14, D15, 200000, true, true);    // OK
//Aqm0802A lcd_(PB_3, PB_10);                     // OK
//Aqm0802A lcd_(PC_9, PA_8);                      // OK
//Aqm0802A lcd_(PB_4, PA_8);                      // OK 

Ticker timer_;

// Display 0, 1, 2, .....
void TimerIsr()
{
    static int k = 0;
    char str[10];
    sprintf(str, "%d", k++);
    lcd_.WriteStringXY(str, 0, 1);
}

int main()
{
    lcd_.Clear();
    lcd_.WriteString("Hello!");
    TimerIsr();
    timer_.attach(&TimerIsr, 1);

    while (true) {}
}

