//--------------------------------------------------------------
//  ADT7410 クラスの使用例
//      割込みを使わない場合は "#define USING_INTERRUPT" を
//      コメントアウトする
//
//  使用した mbed ライブラリ：        Rev.172
//  使用した Aqm1602 用ライブラリ：   Rev.7
//
//  2020/04/16, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------------

#pragma diag_suppress 870   // マルチバイト文字使用の警告を抑制
#define USING_INTERRUPT     // 割込みを使わない場合はコメントアウト
#include "ADT7410.hpp"
using namespace Mikami;

ADT7410 tempr_;     // Nucleo-F446RE のデフォルトの I2C ポート使用

// 温度の読み込みと表示
// この関数は割込みサービス･ルーチンとしても使える
void ReadAndPrintF()
{
    float value = tempr_.Read();    // 温度の読み込み
    printf("%5.1f [℃]\r\n", value);
}

int main()
{
    printf("\r\nADT7410 クラスのデモプログラムの開始\r\n");

#ifdef USING_INTERRUPT
    printf("割込みサービス･ルーチンで温度を読み込みます\r\n");
    Ticker timer;                       // タイマ割込み
    timer.attach(&ReadAndPrintF, 1);    // タイマ割込み間隔： 1 秒
#else
    printf("割込みを使いません\r\n");
#endif

    while (true)
    {
#ifndef USING_INTERRUPT // 割込みを使わない場合
        ReadAndPrint();
        wait(1);
#endif
    }
}