//------------------------------------------------------------
// Demo program for LCD ACM1602NI using I2C interface
//      Pullup resistors for SDA and SCL: 4.7 kΩ
// 2016/04/01, Copyright (c) 2016 MIKAMI, Naoki
//------------------------------------------------------------

#include "ACM1602NI.hpp"
using namespace Mikami;

Acm1602Ni lcd_;                               // Default, OK
//Acm1602Ni lcd_(D14, D15);                     // OK
//Acm1602Ni lcd_(D14, D15, 200000);             // OK
//Acm1602Ni lcd_(D14, D15, 200000, true, true); // OK
//Acm1602Ni lcd_(PB_3, PB_10);                  // OK
//Acm1602Ni lcd_(PC_9, PA_8);                   // OK
//Acm1602Ni lcd_(PB_4, PA_8);                   // OK 

Ticker timer_;

// Display elapsed time in minutes and seconds
void TimerIsr()
{
    static int k = 0;

    div_t ms = div(k, 60);
/*
    char str[20];
    sprintf(str, "%d'%2d\"", ms.quot, ms.rem);
    lcd_.WriteStringXY(str, 0, 1);
*/
    lcd_.WriteValueXY("%d'", ms.quot, 0, 1);
    lcd_.WriteValue("%2d\"", ms.rem);
    k++;
}

int main()
{
    if (lcd_.IsConnected()) printf("\r\nConnected");
    else                    printf("\r\nDisconnected");

    lcd_.WriteString("Hello World!");

    TimerIsr();
    timer_.attach(&TimerIsr, 1);

    while (true) {}
}

