//--------------------------------------------------------------
//  可変 IIR フィルタのクラス
//
//  2022/02/21, Copyright (c) 2022 MIKAMI, Naoki
//--------------------------------------------------------------

#include "IIR_Cascade.hpp"

#ifndef VARIABLE_IIR_FILTER_HPP
#define VARIABLE_IIR_FILTER_HPP

namespace Mikami
{
    class VariableIir
    {
    public:
        // コンストラクタ
        VariableIir() : fPtr2_(&VariableIir::Off)
        {   
            SetOff();   // 最初は出力 Off       
            Validate(); // フィルタ処理有効
        }

        // IIR フィルタの実行
        float Execute(float xn) { return (this->*fPtr_)((this->*fPtr2_)(xn)); }

        // IIR フィルタの係数を設定する
        void SetCoefficients(int order, const Biquad::Coefs ck[], float g0)
        {   iirFilter_.SetCoefs(order, ck, g0); }

        // フィルタの遅延器をクリア
        void Clear() { iirFilter_.Clear(); }

        // IIR フィルタの処理を有効にする
        void Validate() { fPtr_ = &VariableIir::Filtering; }

        // IIR フィルタの処理を無効にする
        void Invalidate() { fPtr_ = &VariableIir::Through; }

        // 出力を On にする    
        void SetOn() { fPtr2_ = &VariableIir::On; }

        // 出力を Off にする
        void SetOff() { fPtr2_ = &VariableIir::Off; }
            
    private:
        IirCascade iirFilter_;

        float (VariableIir::*fPtr_)(float);     // フィルタ処理タの有無
        float (VariableIir::*fPtr2_)(float);    // 出力の On/Off
        
        float Through(float xn) { return xn; }  // そのまま出力
        float Filtering(float xn)               // フィルタを実行して出力
        {   return iirFilter_.Execute(xn); }
        float On(float xn) { return xn; }       // 出力: On
        float Off(float xn) { return 0; }       // 出力: Off

        // コピー･コンストラクタ，代入演算子禁止禁止のため
        VariableIir(const VariableIir&);
        VariableIir& operator=(const VariableIir&);
    };
}
#endif  // VARIABLE_IIR_FILTER_HPP
