//--------------------------------------------------------------
//  縦続形 IIR フィルタの構成要素として使う 2 次の IIR フィルタ
//      b0 は 1 と仮定している
//
//  2022/02/19, Copyright (c) 2022 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef IIR_BIQUAD_HPP
#define IIR_BIQUAD_HPP

#include "mbed.h"

namespace Mikami
{
    class Biquad
    {
    public:
        // フィルタの係数をまとめて扱うための構造体
        struct Coefs { float a1, a2, b1, b2; };

        // デフォルト･コンストラクタ
        //      係数は構造体 Ceofs で与える
        Biquad(const Coefs ck = (Coefs){0, 0, 0, 0})
            : c_(ck), vn1_(0), vn2_(0) {}

        // 2 次のフィルタを実行する
        float Execute(float xn)
        {
            float vn = xn + c_.a1*vn1_ + c_.a2*vn2_;
            float yn = vn + c_.b1*vn1_ + c_.b2*vn2_;
        
            vn2_ = vn1_;
            vn1_ = vn;
 
            return yn;
        }

        // 係数を設定する
        void SetCoefs(const Coefs ck) { c_ = ck; }

        // 内部変数（遅延器）のクリア
        void Clear() { vn1_ = vn2_ = 0; }

    private:
        Coefs c_;
        float vn1_, vn2_;

        // コピー･コンストラクタ禁止のため
        Biquad(const Biquad&);
    };
}
#endif  // IIR_BIQUAD_HPP
