//---------------------------------------------------
//  縦続形 IIR フィルタ
//
//  2022/02/19, Copyright (c) 2022 MIKAMI, Naoki
//---------------------------------------------------

#ifndef IIR_CASCADE_HPP
#define IIR_CASCADE_HPP

#include "Biquad.hpp"
#include "Array.hpp"    // Array クラスが定義されている

namespace Mikami
{
    class IirCascade
    {
    public:
        // コンストラクタ
        IirCascade(int order = 0, const Biquad hk[] = NULL, float g0 = 1)
            : order_(order), hn_((order+1)/2, hk), g0_(g0) {}

        // フィルタ処理を実行する
        float Execute(float xn)
        {
            float yn = g0_*xn;
            for (int k=0; k<(order_+1)/2; k++) yn = hn_[k].Execute(yn);
            return yn;
        }

        // 係数の設定
        void SetCoefs(int order, const Biquad::Coefs ck[], float g0)
        {
            if (order_ != order)
            {
                order_ = order;
                hn_.SetSize((order+1)/2);
            }
            g0_ = g0;
            for (int k=0; k<(order+1)/2; k++) hn_[k].SetCoefs(ck[k]);
        }

        // 内部変数（遅延器）のクリア
        void Clear()
        {   for (int k=0; k<(order_+1)/2; k++) hn_[k].Clear(); }

    private:
        int order_;         // 次数
        Array<Biquad> hn_;  // Biquad クラスのオブジェクトの配列
        float g0_;          // 利得定数

        // コピー･コンストラクタ，代入演算子禁止禁止のため
        IirCascade(const IirCascade&);
        IirCascade& operator=(const IirCascade&);
    };
}
#endif  // IIR_CASCADE_HPP
