//----------------------------------------------------------------------
//  IIR フィルタの係数，縦続形，float 型
//
//  2020/10/17, Copyright (c) 2020 MIKAMI, Naoki
//
//  セミナ用に遮断周波数を低くしたバージョン
//----------------------------------------------------------------------

#include "Biquad.hpp"
using namespace Mikami;
/*
// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 4 次
// 標本化周波数：400.00 kHz
// 遮断周波数　： 20.00 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const int ORDER_ = 4;
const Biquad::Coefs hk_[] = {
    { 1.712306E+00f, -7.512093E-01f, -9.111378E-01f, 1.0f},
    { 1.819915E+00f, -9.194769E-01f, -1.719255E+00f, 1.0f}};
const float G0_ = 1.196187E-02f;    // 利得定数
*/
// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 4 次
// 標本化周波数：400.0000 kHz
// 遮断周波数　：  4.0000 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const int ORDER_ = 4;
const Biquad::Coefs hk_[] = {
    { 1.942874E+00f, -9.445931E-01f, -1.941953E+00f, 1.0f},
    { 1.978919E+00f, -9.830717E-01f, -1.988148E+00f, 1.0f}};
const float G0_ = 9.797098E-03f;    // 利得定数
