//-----------------------------------------------------------
//  FastSin() 関数
//      sin(πx/2) の値の計算
//
//  2020/06/01, Copyright (c) 2020 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef FASTSIN_POLYNOMIAL_HPP
#define FASTSIN_POLYNOMIAL_HPP

namespace Mikami
{
    // 引数の範囲： -2 <= x <= 2
    inline float FastSin(float x)
    {
        static const float A1 =  1.570320019210f;
        static const float A3 = -0.642113166941f;
        static const float A5 =  0.071860854119f;

        if (x >  1.0f) x =  2.0f - x;
        if (x < -1.0f) x = -2.0f - x;
        float x2 = x*x;
        return ((A5*x2 + A3)*x2 + A1)*x;
    }
}
#endif  // FASTSIN_POLYNOMIAL_HPP
