//-------------------------------------------------------------
//  STM32F446 内蔵の DAC 用のクラス
//      DAC_OUT1: A2  (PA_4)
//      DAC_OUT2: D13 (PA_5)
//
//  2020/10/17, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "F446_DAC.hpp"

namespace Mikami
{
    DacF446::DacF446(PinName pin) : da_(pin)
    {
        MBED_ASSERT((pin == A2) || (pin == D13));

        if (pin == A2)
        {
            DAC->CR = DAC_CR_EN1;
            fpWriteDac = &DacF446::WriteDac1;
        }
        else
        {
            DAC->CR = DAC_CR_EN2;
            fpWriteDac = &DacF446::WriteDac2;
        }
    }
}
