//-------------------------------------------------------------------
// デフォルトの補間用フィルタの係数
//      この係数は，入力の標本化周波数を 10 kHz，
//      出力の標本化周波数を 40 kHz として設計した
//
//  2021/12/22, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------------------

#include "MultirateLiPh.hpp"

namespace Mikami
{
    // 使用窓関数   Kaiser 窓
    // 標本化周波数 (kHz)   40.000000
    // 次数          72
    // 種類         LPF
    // 遮断周波数 (kHz)      5.000000
    // 減衰量 (dB)  40.00
    const int MultirateLiPh::ORDER_ = 72;
    const float MultirateLiPh::HK1_[] = {
         4.431256E-03f, -8.146596E-03f,  1.341366E-02f, -2.077330E-02f,
         3.116614E-02f, -4.650688E-02f,  7.151836E-02f, -1.218529E-01f,
         2.971602E-01f,  8.993316E-01f, -1.751857E-01f,  9.144896E-02f,
        -5.727932E-02f,  3.802786E-02f, -2.550498E-02f,  1.678651E-02f,
        -1.055827E-02f,  6.120216E-03f};
    const float MultirateLiPh::HK2_[] = {
         7.405152E-03f, -1.315348E-02f,  2.125564E-02f, -3.257789E-02f,
         4.868468E-02f, -7.290120E-02f,  1.139337E-01f, -2.039652E-01f,
         6.338376E-01f,  6.338376E-01f, -2.039652E-01f,  1.139337E-01f,
        -7.290120E-02f,  4.868468E-02f, -3.257789E-02f,  2.125564E-02f,
        -1.315348E-02f,  7.405152E-03f};
    const float MultirateLiPh::HK3_[] = {
         6.120216E-03f, -1.055827E-02f,  1.678651E-02f, -2.550498E-02f,
         3.802786E-02f, -5.727932E-02f,  9.144896E-02f, -1.751857E-01f,
         8.993316E-01f,  2.971602E-01f, -1.218529E-01f,  7.151836E-02f,
        -4.650688E-02f,  3.116614E-02f, -2.077330E-02f,  1.341366E-02f,
        -8.146596E-03f,  4.431256E-03f};
}